<?php
require __DIR__ . '/connection_secundaria.php';
header('Content-Type: application/json');

ini_set('display_startup_errors', 1);
ini_set('display_errors', 1);
error_reporting(-1);
set_time_limit(0);

$fileId = $_POST['file_id'] ?? '';
if (!$fileId) {
    echo json_encode(['ok'=>false,'error'=>"No se recibi file_id."]);
    exit;
}

$tableSource = $fileId . "_transferido"; 

$conn_secundaria->query("ALTER TABLE `$tableSource` ADD COLUMN IF NOT EXISTS SMTP_status VARCHAR(30) DEFAULT NULL");

$batchSize = 100;
$offset = 0;

$total = 0;
$validCount = 0;
$invalidCount = 0;
$unknownCount = 0;
$catchAllCount = 0;

$dominiosCatchAllComunes = [
    'gmail.com','googlemail.com','outlook.com','hotmail.com',
    'live.com','yahoo.com','icloud.com','aol.com','msn.com','protonmail.com'
];

function tieneMX($domain) {
    return checkdnsrr($domain,'MX');
}
function tieneSPF($domain) {
    $txts = dns_get_record($domain,DNS_TXT);
    foreach ($txts as $txt) {
        if (isset($txt['txt']) && stripos($txt['txt'],'v=spf1') !== false) return true;
    }
    return false;
}
function tieneDMARC($domain) {
    $txts = dns_get_record("_dmarc.$domain",DNS_TXT);
    foreach ($txts as $txt) {
        if (isset($txt['txt']) && stripos($txt['txt'],'v=dmarc1') !== false) return true;
    }
    return false;
}

function smtp_validate_email($email, $from = 'info@valorpoint.net') {
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return false;
    }

    list($username, $domain) = explode('@', $email);

    if (!getmxrr($domain, $mxhosts)) {
        $mxhosts = [$domain];
    }

    foreach ($mxhosts as $mx) {
        $connection = @fsockopen($mx, 25, $errno, $errstr, 8);
        if (!$connection) continue;

        $response = fgets($connection);
        if (!preg_match('/^220/', $response)) {
            fclose($connection);
            continue;
        }

        fputs($connection, "EHLO tudominio.com\r\n");
        fgets($connection);

        fputs($connection, "MAIL FROM:<$from>\r\n");
        fgets($connection);

        fputs($connection, "RCPT TO:<$email>\r\n");
        $rcpt = fgets($connection);

        fputs($connection, "QUIT\r\n");
        fclose($connection);

        if (preg_match('/^250|^251/', $rcpt)) {
            return true;
        }
    }

    return false;
}

while (true) {
    $sql = "SELECT Id, Email FROM `$tableSource` WHERE SMTP_status IS NULL LIMIT $offset, $batchSize";
    $result = $conn_secundaria->query($sql);
    if (!$result || $result->num_rows === 0) break;

    $emails = [];
    while ($row = $result->fetch_assoc()) {
        $emails[] = $row;
    }

    foreach ($emails as $row) {
        $id = $row['Id'];
        $email = $row['Email'];
        $domain = substr(strrchr($email, "@"), 1);

        $status = 'unknown';

        if (in_array($domain, $dominiosCatchAllComunes)) {
            $status = 'valid_known';
            $catchAllCount++;
        } elseif (!tieneMX($domain) && !tieneSPF($domain) && !tieneDMARC($domain)) {
            $status = 'invalid_domain';
            $invalidCount++;
        } else {
            $isSMTPValid = smtp_validate_email($email);
            $status = $isSMTPValid ? 'smtp_valid' : 'smtp_invalid';
            if ($isSMTPValid) $validCount++;
            else $unknownCount++;
        }

        $sqlUpdate = "UPDATE `$tableSource` SET SMTP_status = '$status' WHERE Id = $id";
        $conn_secundaria->query($sqlUpdate);
        $total++;
    }

    $offset += $batchSize;
}

$conn_secundaria->close();

echo json_encode([
    'ok' => true,
    'file_id' => $fileId,
    'tabla' => $tableSource,
    'mensaje' => "Verificacin SMTP completada. Total: $total, Vlidos: $validCount, Invlidos: $invalidCount, Desconocidos: $unknownCount, CatchAll: $catchAllCount"
]);
exit;